package cc.smarnet.tscdemo;

import android.app.Activity;
import android.app.AlertDialog;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;


/**
 * Created by Administrator
 *
 * @author 猿史森林
 *         Date: 2017/11/30
 *         Class description:
 */
public class WifiParameterConfigDialog {
    private Activity mContext;
    private SharedPreferencesUtil sharedPreferencesUtil;
    private WifiConfigCallback wifiConfigCallback;
    public interface WifiConfigCallback{
        void callback(String ip, int port);
    }


    public WifiParameterConfigDialog(Activity context,WifiConfigCallback callback) {
        mContext = context;
        this.wifiConfigCallback = callback;
    }

    public void show(){
        View contentView = View.inflate(mContext, R.layout.dialog_wifi_config, null);
        final EditText etWifiIpConfig = (EditText) contentView.findViewById(R.id.et_wifi_ip);
        final EditText etWifiPortConfig = (EditText) contentView.findViewById(R.id.et_wifi_port);
        sharedPreferencesUtil = SharedPreferencesUtil.getInstantiation(mContext);
        final String ip = sharedPreferencesUtil.getString(Constant.WIFI_DEFAULT_IP, Constant.WIFI_CONFIG_IP);
        final String port = String.valueOf(sharedPreferencesUtil.getInt(Constant.WIFI_DEFAULT_PORT, Constant.WIFI_CONFIG_PORT));
        etWifiIpConfig.setText(ip);
        etWifiPortConfig.setText(port);
        AlertDialog alertDialog = new AlertDialog.Builder(mContext).setView(contentView)
                .setNegativeButton(mContext.getString(R.string.str_confirm), (dialog, which) -> {
                    final String strIp = etWifiIpConfig.getText().toString().trim();
                    final String strPort = etWifiPortConfig.getText().toString().trim();
                    System.out.println("strIp --> " + strIp + "\tstrPort --> " + strPort);
                    if (!TextUtils.isEmpty(strIp) && !TextUtils.isEmpty(strPort)) {
                        if (!strIp.equals(ip)) {
                            sharedPreferencesUtil.putString(strIp, Constant.WIFI_CONFIG_IP);
                        }
                        if (!strPort.equals(port)) {
                            sharedPreferencesUtil.putInt(Integer.parseInt(strPort), Constant.WIFI_CONFIG_PORT);
                        }
                        wifiConfigCallback.callback(strIp,Integer.parseInt(strPort));
                    }
                })
                .setPositiveButton(mContext.getString(R.string.str_cancel), (dialog, which) -> {

                }).show();
        alertDialog.setCanceledOnTouchOutside(false);
    }
}
